CREATE TABLE AB18A12T00
(
	T12_ID_EVENTO		 		NUMBER(5)  		NOT NULL ,
	T07_ID_TICKET				NUMBER(5)  		NOT NULL ,
	T11_ID_ESTADO		 		NUMBER(5)  		NOT NULL ,
	T12_FECHA_ACTUALIZACION		DATE		 		NULL,
	T12_FECHA_PUBLICACION		DATE		 		NULL,
	T12_COD_EXPEDIENTE	 		VARCHAR2(10)  		NULL,
	T12_DESC_ERROR	 			VARCHAR2(150) 		NULL
)
	TABLESPACE AB18A01E00;


COMMENT ON TABLE AB18A12T00 IS 'EVENTOS.';


COMMENT ON COLUMN AB18A12T00.T12_ID_EVENTO IS 'Identificativo del registro de la tabla.';

COMMENT ON COLUMN AB18A12T00.T07_ID_TICKET IS 'Id del ticket con que está asociado el evento.';

COMMENT ON COLUMN AB18A12T00.T11_ID_ESTADO IS 'Id del estado de la petición al lanzarse el evento.';

COMMENT ON COLUMN AB18A12T00.T12_FECHA_ACTUALIZACION IS 'Fecha de actualización del registro.';

COMMENT ON COLUMN AB18A12T00.T12_FECHA_PUBLICACION IS 'Fecha de publicación.';

COMMENT ON COLUMN AB18A12T00.T12_COD_EXPEDIENTE IS 'Código del expediente.';

COMMENT ON COLUMN AB18A12T00.T12_DESC_ERROR IS 'Descripción del error.';

ALTER TABLE AB18A12T00
	ADD (CONSTRAINT  PK_AB18A12T00 PRIMARY KEY (T12_ID_EVENTO)
	USING INDEX
  TABLESPACE AB18A02E00);
  COMMIT;

